#include <stdio.h>
#include <stdlib.h>

typedef enum{false, true} boolean;

struct elemento
{
    int info;
    struct elemento *next;
};

typedef struct elemento ElementoDiLista;
typedef ElementoDiLista *ListaDiElementi;

void InserisciCoda(ListaDiElementi *lista, int elem);
boolean ControlloOrdinata(ListaDiElementi lista);

int main(void)
{
    ListaDiElementi lista = NULL;

    int valoreDaInserire;

    do
    {
        InserisciCoda(&lista, valoreDaInserire);
        scanf("%d", &valoreDaInserire);
    }while(valoreDaInserire >= 0);

    boolean rst = ControlloOrdinata(lista);

    if(rst == false)
    {
        printf("False");
    }
    else
    {
        printf("True");
    }

	return 0;
}

void InserisciCoda(ListaDiElementi *lista, int elem)
{
	ListaDiElementi ultimo;

    ListaDiElementi aux;
    aux = malloc(sizeof(ElementoDiLista));
    aux->info = elem;
    aux->next = NULL;
	
    if(*lista == NULL)
    {
        *lista = aux;
    }
    else
    {
        ultimo = *lista;
        while(ultimo->next != NULL)
        {
            ultimo = ultimo->next;
        }
        ultimo->next = aux;
    }
}

boolean ControlloOrdinata(ListaDiElementi lista)
{
    ListaDiElementi precedente;
    precedente = lista;

	ListaDiElementi corrente;
    corrente = (precedente-> next);

    if(corrente != NULL)
    {
        if(corrente >= precedente)
        {
            ControlloOrdinata(lista->next);
        }
        else
        {
            return false;
        }
    }
    return true;
}